/*
 * Decompiled with CFR 0.152.
 */
package de.unhappycodings.quarry.common.blocks;

import de.unhappycodings.quarry.common.blockentity.ModBlockEntities;
import de.unhappycodings.quarry.common.blockentity.QuarryBlockEntity;
import de.unhappycodings.quarry.common.network.PacketHandler;
import de.unhappycodings.quarry.common.network.toserver.QuarryBooleanPacket;
import de.unhappycodings.quarry.common.network.toserver.QuarryIntPacket;
import de.unhappycodings.quarry.common.network.toserver.QuarryModePacket;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuarryBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty POWERED = BooleanProperty.m_61465_((String)"powered");
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final BooleanProperty WORKING = BooleanProperty.m_61465_((String)"working");

    public QuarryBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_).m_60913_(3.0f, 6.0f));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WORKING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public void m_6402_(Level pLevel, @NotNull BlockPos pPos, @NotNull BlockState pState, @Nullable LivingEntity pPlacer, @NotNull ItemStack pStack) {
        QuarryBlockEntity blockEntity = (QuarryBlockEntity)pLevel.m_7702_(pPos);
        if (Objects.equals(blockEntity.getOwner(), "undefined") || !Objects.equals(blockEntity.getOwner(), "@")) {
            blockEntity.setOwner(pPlacer.m_7755_().getString() + "@" + pPlacer.m_20149_());
        }
        blockEntity.m_6596_();
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level levelIn, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult hit) {
        if (!Objects.equals(((QuarryBlockEntity)levelIn.m_7702_(pos)).getOwner(), player.m_7755_().getString() + "@" + player.m_20149_()) && ((QuarryBlockEntity)levelIn.m_7702_(pos)).getLocked() && !player.m_20310_(2)) {
            if (levelIn.f_46443_ && handIn == InteractionHand.MAIN_HAND) {
                String owner = ((QuarryBlockEntity)levelIn.m_7702_(pos)).getOwner();
                if (owner.isEmpty()) {
                    owner = "undefined";
                }
                player.m_213846_((Component)Component.m_237115_((String)"gui.quarry.message.quarry_from").m_130946_(" " + owner.split("@")[0] + " ").m_7220_((Component)Component.m_237115_((String)"gui.quarry.message.is_locked")).m_130940_(ChatFormatting.YELLOW));
            }
            return InteractionResult.SUCCESS;
        }
        MenuProvider namedContainerProvider = this.m_7246_(state, levelIn, pos);
        if (namedContainerProvider != null) {
            if (levelIn.f_46443_) {
                PacketHandler.sendToServer(new QuarryIntPacket(pos, 0, "speed"));
                PacketHandler.sendToServer(new QuarryModePacket(pos, -1));
                PacketHandler.sendToServer(new QuarryBooleanPacket(pos, true, "locked"));
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayerEntity = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)serverPlayerEntity, (MenuProvider)namedContainerProvider, (BlockPos)pos);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_214162_(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.m_61143_((Property)POWERED)).booleanValue()) {
            double d0 = (double)pPos.m_123341_() + 0.5;
            double d1 = pPos.m_123342_();
            double d2 = (double)pPos.m_123343_() + 0.5;
            if (pRandom.m_188500_() < 0.1) {
                pLevel.m_7785_(d0, d1, d2, SoundEvents.f_11907_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)pState.m_61143_((Property)FACING);
            Direction.Axis directionAxis = direction.m_122434_();
            double d3 = 0.52;
            double d4 = pRandom.m_188500_() * 0.6 - 0.3;
            double d5 = directionAxis == Direction.Axis.X ? (double)direction.m_122429_() * 0.52 : d4;
            double d6 = pRandom.m_188500_() * 6.0 / 16.0;
            double d7 = directionAxis == Direction.Axis.Z ? (double)direction.m_122431_() * 0.52 : d4;
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123762_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
            pLevel.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0 + d5, d1 + d6, d2 + d7, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public BlockState m_5573_(@NotNull BlockPlaceContext pContext) {
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WORKING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED, WORKING, ACTIVE, FACING});
    }

    @NotNull
    public RenderShape m_7514_(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @NotNull BlockState blockState, @NotNull BlockEntityType<T> type) {
        return level.f_46443_ ? null : (a, b, c, blockEntity) -> ((QuarryBlockEntity)blockEntity).tick();
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)ModBlockEntities.QUARRY_BLOCK.get()).m_155264_(pos, state);
    }
}

